#!/bin/sh
PATH=/bin:/usr/bin:/sbin:/usr/sbin export PATH

######################## create_augments.sh ########################
# Mike Bombich | mike@bombich.com
# Copyright 2008 Mike Bombich
####################################################################
#
## DISCLAIMER ##
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
##
#
#
## DESCRIPTION ##
#
# This script automates the creation of augment records for users.
# This script will create augment records that include three augmented
# attributes: 
#
#	dsAttrTypeStandard:HomeDirectory
#	dsAttrTypeStandard:NFSHomeDirectory
#	dsAttrTypeStandard:Keywords
#
# Be sure that you have updated your OD Master's augmentconfiguration
# record to permit augmentation of all three of these attributes
#
# Note: You need to edit the "auth diradmin apple" line on line 73
# to indicate the username and password of your directory administrator
# account
#
# Note #2: This script requires the "mbr_enum" utility available at
# http://www.bombich.com/mactips/scripts.html#augments
#
# Note #3: The mbr_enum utility can be demanding on the foreign directory
# service as it recursively determines the members of groups and nested 
# groups. Carefully consider this before passing large groups into this
# script. For example, passing "Domain Users" is probably a bad idea
#


# Edit the following settings to match your environment
mbr_enum=/Users/apple/Desktop/mbr_enum
dry_run=yes # set to "no" when you're ready to do this for real
ODM=/LDAPv3/master.apple.edu
home_url="afp://services.apple.edu/Users"
home_path=/Network/Servers/services.apple.edu/Users
group=od_test_nest
pgid=20



if [ $dry_run == "no" ]; then
	mkfifo /tmp/f
	dscl $ODM < /tmp/f &
else
	rm /tmp/f
fi

$mbr_enum "$group" | awk -v home_url="$home_url" \
  -v home_path="$home_path" -v group="$group" -v pgid="$pgid" '
BEGIN {
	FS = "^"
	print "auth diradmin apple" >> "/tmp/f"
}
{
	sn=$1
	ln=$2
	uid=$3
	"uuidgen" | getline uuid

	printf("create /Augments/Users:%s RealName \"%s\"\n", sn, ln) >> "/tmp/f"
	printf("create /Augments/Users:%s GeneratedUID %s\n", sn, uuid) >> "/tmp/f"
	printf("create /Augments/Users:%s HomeDirectory <home_dir><url>%s</url><path>%s</path></home_dir>\n", sn, home_url, sn) >> "/tmp/f"
	printf("create /Augments/Users:%s NFSHomeDirectory %s/%s\n", sn, home_path, sn) >> "/tmp/f"
	printf("create /Augments/Users:%s UniqueID %s\n", sn, uid) >> "/tmp/f"
	printf("create /Augments/Users:%s PrimaryGroupID %s\n", sn, pgid) >> "/tmp/f"
	printf("create /Augments/Users:%s Keywords \"%s\"\n", sn, group) >> "/tmp/f"
}'

if [ $dry_run == "no" ]; then
	rm /tmp/f
else
	open -e /tmp/f
fi
